/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPdDto;

/**
 * ^׃NXB<br>
 */
public class Payment extends PayrollSlip {
	
	private static final long serialVersionUID = -6106880371454177891L;
	
	/**
	 * ^wb_[B<br>
	 */
	private PhPaymentDto header;
	
	/**
	 * ΑӖ׏B<br>
	 */
	private List<DetailTimeDto> time;
	
	/**
	 * x׏B<br>
	 */
	private List<DetailPaDto> allowance;
	
	/**
	 * T׏B<br>
	 */
	private List<DetailPdDto> deduction;
	
	/**
	 * 󖾍׏B<br>
	 */
	private List<DetailPbDto> breakdown;
	
	/**
	 * v׏B<br>
	 */
	private List<DetailMoneyDto> sum;
	
	/**
	 * CX^X𐶐AtB[hݒ肷B<br>
	 * @param header    ^wb_[
	 * @param time      ΑӖ׏
	 * @param allowance x׏
	 * @param deduction T׏
	 * @param breakdown 󖾍׏
	 * @param sum       v׏
	 */
	public Payment(
			PhPaymentDto         header   ,
			List<DetailTimeDto > time     ,
			List<DetailPaDto   > allowance,
			List<DetailPdDto   > deduction,
			List<DetailPbDto   > breakdown,
			List<DetailMoneyDto> sum      
	) {
		this.header    = header   ;
		this.time      = time     ;
		this.allowance = allowance;
		this.deduction = deduction;
		this.breakdown = breakdown;
		this.sum       = sum      ;
		initDetails();
	}
	
	/**
	 * CX^X𐶐AtB[hݒ肷B<br>
	 * @param header          ^wb_[
	 * @param time            ΑӖ׏
	 * @param allowance       x׏
	 * @param deduction       T׏
	 * @param breakdown       󖾍׏
	 * @param sum             v׏
	 * @param amountTime      ΑӖ׏
	 * @param amountAllowance x׏
	 * @param amountDeduction T׏
	 * @param amountBreakdown 󖾍׏
	 * @param amountSum       v׏
	 */
	public Payment(
			PhPaymentDto         header         ,
			List<DetailTimeDto > time           ,
			List<DetailPaDto   > allowance      ,
			List<DetailPdDto   > deduction      ,
			List<DetailPbDto   > breakdown,
			List<DetailMoneyDto> sum            ,
			List<DetailTimeDto > amountTime     ,
			List<DetailMoneyDto> amountAllowance,
			List<DetailMoneyDto> amountDeduction,
			List<DetailTimeDto > amountBreakdown,
			List<DetailMoneyDto> amountSum      
	) {
		this.header    = header   ;
		this.time      = time     ;
		this.allowance = allowance;
		this.deduction = deduction;
		this.breakdown = breakdown;
		this.sum       = sum      ;
		initDetails();
		setDetailsAmount(time     , amountTime     );
		setDetailsAmount(allowance, amountAllowance);
		setDetailsAmount(deduction, amountDeduction);
		setDetailsAmount(breakdown, amountBreakdown);
		setDetailsAmount(sum      , amountSum      );
	}
	
	/**
	 * ׂB
	 */
	private void initDetails() {
		initDetails(time     , getKCode(), getCalcMonth());
		initDetails(allowance, getKCode(), getCalcMonth());
		initDetails(deduction, getKCode(), getCalcMonth());
		initDetails(breakdown, getKCode(), getCalcMonth());
		initDetails(sum      , getKCode(), getCalcMonth());
	}
	
	/**
	 * גlvZB
	 * @param mapParams p[^Map
	 * @throws MospException 
	 */
	public void calcDetails(Map<String, String> mapParams) throws MospException {
		calcDetails(time     , mapParams);
		calcDetails(allowance, mapParams);
		calcDetails(deduction, mapParams);
		calcDetails(breakdown, mapParams);
		calcDetails(sum      , mapParams);
	}
	
	/**
	 * גlݒ肷B
	 * @param aryTime      ΑӖגl
	 * @param aryAllowance xגl
	 * @param aryDeduction Tגl
	 * @param aryBreakdown 󖾍גl
	 */
	public void setDetails(
			String[][] aryTime     ,
			String[][] aryAllowance,
			String[][] aryDeduction,
			String[][] aryBreakdown
	) {
		setDetails(time     , aryTime     );
		setDetails(allowance, aryAllowance);
		setDetails(deduction, aryDeduction);
		setDetails(breakdown, aryBreakdown);
	}
	
	/**
	 * ΑӖגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setTimeAmount(String detailCode, float amount) {
		setDetailAmount(getDetailDto(time, detailCode), amount);
	}
	
	/**
	 * xגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setAllowanceAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(allowance, detailCode), amount);
	}
	
	/**
	 * Tגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setDeductionAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(deduction, detailCode), amount);
	}
	
	/**
	 * 󖾍גlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setBreakdownAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(breakdown, detailCode), amount);
	}
	
	/**
	 * vגlݒ肷B
	 * @param detailCode ׃R[h
	 * @param amount גl
	 */
	public void setSumAmount(String detailCode, int amount) {
		setDetailAmount(getDetailDto(sum, detailCode), amount);
	}
	
	/**
	 * ΑӖגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public float getTimeAmount(String detailCode) {
		return getDetailAmount(time, detailCode);
	}
	
	/**
	 * xגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getAllowanceAmount(String detailCode) {
		return (int)getDetailAmount(allowance, detailCode);
	}
	
	/**
	 * Tגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getDeductionAmount(String detailCode) {
		return (int)getDetailAmount(deduction, detailCode);
	}
	
	/**
	 * 󖾍גl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public float getBreakdownAmount(String detailCode) {
		return getDetailAmount(breakdown, detailCode);
	}
	
	/**
	 * vגl擾B
	 * @param detailCode ׃R[h
	 * @return גl
	 */
	public int getSumAmount(String detailCode) {
		return (int)getDetailAmount(sum, detailCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param kCode ݒ肷ЈR[h
	 */
	public void setKCode(String kCode) {
		header.setKCode(kCode);
	}
	
	/**
	 * ЈR[h擾B<br>
	 * @return ЈR[h
	 */
	public String getKCode() {
		return header.getKCode();
	}
	
	/**
	 * vZNݒ肷B<br>
	 * @param calcDate ݒ肷vZN
	 */
	public void setCalcDate(Date calcDate) {
		header.setCalcMonth(calcDate);
	}
	
	/**
	 * vZN擾B<br>
	 * @return vZN
	 */
	public Date getCalcMonth() {
		return header.getCalcMonth();
	}
	
	/**
	 * xݒ肷B<br>
	 * @param payDate ݒ肷x
	 */
	public void setPayDate(Date payDate) {
		header.setPayDate(payDate);
	}
	
	/**
	 * `[R[hݒ肷B<br>
	 * @param slipCode ݒ肷`[R[h
	 */
	public void setSlipCode(String slipCode) {
		header.setSlipCode(slipCode);
	}
	
	/**
	 * ^wb_[擾B
	 * @return גl
	 */
	public PhPaymentDto getHeader() {
		return header;
	}
	
	/**
	 * ΑӖהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getTimeArray(boolean checkDisplayType) {
		return getAryDetail(time, checkDisplayType);
	}
	
	/**
	 * xהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getAllowanceArray(boolean checkDisplayType) {
		return getAryDetail(allowance, checkDisplayType);
	}
	
	/**
	 * Tהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getDeductionArray(boolean checkDisplayType) {
		return getAryDetail(deduction, checkDisplayType);
	}
	
	/**
	 * 󖾍הz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getBreakdownArray(boolean checkDisplayType) {
		List<DetailPbDto> view = new ArrayList<DetailPbDto>();
		for (Iterator<DetailPbDto> it =breakdown.iterator(); it.hasNext();) {
			DetailPbDto dto = it.next();
			if (dto.getViewType() == PayrollConst.DETAIL_VIEW_ON) {
				view.add(dto);
			}
		}
		return getAryDetail(view, checkDisplayType);
	}
	
	/**
	 * vהz擾B
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	public String[][] getSumArray(boolean checkDisplayType) {
		return getAryDetail(sum, checkDisplayType);
	}
	
	/**
	 * ΑӖ׃Xg擾B
	 * @return ׃Xg
	 */
	public List<DetailTimeDto> getTimeList() {
		return time;
	}
	
	/**
	 * x׃Xg擾B
	 * @return ׃Xg
	 */
	public List<DetailPaDto> getAllowanceList() {
		return allowance;
	}
	
	/**
	 * T׃Xg擾B
	 * @return ׃Xg
	 */
	public List<DetailPdDto> getDeductionList() {
		return deduction;
	}
	
	/**
	 * 󖾍׃Xg擾B
	 * @return ׃Xg
	 */
	public List<DetailPbDto> getBreakdownList() {
		return breakdown;
	}
	
	/**
	 * v׃Xg擾B
	 * @return ׃Xg
	 */
	public List<DetailMoneyDto> getSumList() {
		return sum;
	}
	
	/**
	 * vZN擾B<br>
	 * @return vZN
	 */
	public String getCalcMonthStr() {
		return MospUtility.getDateString(getCalcMonth(), PayrollConst.FORMAT_YEAR_MONTH);
	}
	
	/**
	 * x擾B
	 * @return x
	 */
	public String getPayDate() {
		return MospUtility.getDateString(header.getPayDate(), PayrollConst.FORMAT_DATE);
	}
	
	/**
	 * ېőΏۊz擾B
	 * @return ېőΏۊz
	 */
	public int getTaxation() {
		return header.getTaxation();
	}

	/**
	 * ٗpیΏۊz擾B
	 * @return ٗpیΏۊz
	 */
	public int getInsureUnemploy() {
		return header.getInsureUnemploy();
	}

	/**
	 * Љیv擾B
	 * @return Љیv
	 */
	public int getSocInsTotal() {
		return header.getSocInsTotal();
	}

	/**
	 * }{̐擾B
	 * @return }{̐
	 */
	public int getDependent() {
		return header.getDependent();
	}
	
	/**
	 * Ŋz擾B
	 * @return Ŋz
	 */
	public int getIncomeTax() {
		return header.getIncomeTax();
	}
	
	/**
	 * ܗ^vZΏۊz擾B
	 * @return ܗ^vZΏۊz
	 */
	public int getBonusBase() {
		return header.getBonusBase();
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getAllowanceTotal() {
		return header.getAllowanceTotal();
	}
	
	/**
	 * Tz擾B
	 * @return Tz
	 */
	public int getDeductionTotal() {
		return header.getDeductionTotal();
	}
	
	/**
	 * xz擾B
	 * @return xz
	 */
	public int getPaymentTotal() {
		return header.getPaymentTotal();
	}
	
	/**
	 * ʋΎ蓖ݒ肷B
	 * @param amount ʋΎ蓖
	 */
	public void setCommutation(int amount) {
		setDetailAmount(getDetailDto(allowance, PayrollConst.DTL_COMMUTATION), amount);
	}
	
	/**
	 * ېŒʋΎ蓖ݒ肷B
	 * @param amount ېŒʋΎ蓖
	 */
	public void setCommuteTax(int amount) {
		setDetailAmount(getDetailDto(breakdown, PayrollConst.DTL_COMMUTE_TAX), amount);
	}
	
	/**
	 * Nیݒ肷B
	 * @param amount Nی
	 */
	public void setHealthInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_HEALTH_INS), amount);
	}
	
	/**
	 * یݒ肷B
	 * @param amount ی
	 */
	public void setNursingInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_NURSING_INS), amount);
	}
	
	/**
	 * Nݒ肷B
	 * @param amount N
	 */
	public void setPensionInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_PENSION_INS), amount);
	}
	
	/**
	 * Nݒ肷B
	 * @param amount N
	 */
	public void setPensionFund(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_PENSION_FUND), amount);
	}
	
	/**
	 * ٗpیݒ肷B
	 * @param amount ٗpی
	 */
	public void setEmployeeInsurance(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_EMPLOYEE_INS), amount);
	}
	
	/**
	 * łݒ肷B
	 * @param amount ݒ肷鏊
	 */
	public void setIncomeTax(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_INCOME_TAX), amount);
		header.setIncomeTax(amount);
	}
	
	/**
	 * Złݒ肷B
	 * @param amount ݒ肷Z
	 */
	public void setResidenceTax(int amount) {
		setDetailAmount(getDetailDto(deduction, PayrollConst.DTL_RESIDENCE_TAX), amount);
	}
	
	/**
	 * s1Uzݒ肷B
	 * @param amount ݒ肷s1Uz
	 */
	public void setBank1PayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_BANK1), amount);
	}
	
	/**
	 * s2Uzݒ肷B
	 * @param amount ݒ肷s2Uz
	 */
	public void setBank2PayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_BANK2), amount);
	}
	
	/**
	 * xzݒ肷B
	 * @param amount ݒ肷s1Uz
	 */
	public void setCashPayAmount(int amount) {
		setDetailAmount(getDetailDto(sum, PayrollConst.DTL_SUM_CASH), amount);
	}
	
	/**
	 * ЉیvvZB
	 */
	public void calcSocInsTotal() {
		long sum = 
			getDeductionAmount(PayrollConst.DTL_HEALTH_INS  ) +
			getDeductionAmount(PayrollConst.DTL_NURSING_INS ) +
			getDeductionAmount(PayrollConst.DTL_PENSION_INS ) +
			getDeductionAmount(PayrollConst.DTL_PENSION_FUND) +
			getDeductionAmount(PayrollConst.DTL_EMPLOYEE_INS);
		setSumAmount(PayrollConst.DTL_SUM_SOC_INS, (int)sum);
		header.setSocInsTotal((int)sum);
	}
	
	/**
	 * xzvZB
	 */
	public void calcAllowance() {
		long sum = 0L;
		for (Iterator<DetailPaDto> it = allowance.iterator(); it.hasNext();) {
			sum += it.next().getAmount();
		}
		sum = sum < 0 ? 0 : sum;
		setSumAmount(PayrollConst.DTL_SUM_ALLOWANCE, (int)sum);
		header.setAllowanceTotal((int)sum);
	}
	
	/**
	 * TzvZB
	 */
	public void calcDeduction() {
		long sum = 0L;
		for (Iterator<DetailPdDto> it = deduction.iterator(); it.hasNext();) {
			sum += it.next().getAmount();
		}
		sum = sum < 0 ? 0 : sum;
		setSumAmount(PayrollConst.DTL_SUM_DEDUCTION, (int)sum);
		header.setDeductionTotal((int)sum);
	}
	
	/**
	 * xzvZB
	 */
	public void calcPaymentTotal() {
		long sum = 0L;
		sum = getAllowanceTotal() - getDeductionTotal();
		setSumAmount(PayrollConst.DTL_SUM_TOTAL, (int)sum);
		header.setPaymentTotal((int)sum);
	}
	
	/**
	 * ٗpیΏۊzvZB
	 */
	public void calcUnemployInsuration() {
		long insureUnemploy = 0L;
		for (Iterator<DetailPaDto> it = allowance.iterator(); it.hasNext();) {
			DetailPaDto dto = it.next();
			if (dto.getUeInsType() == PayrollConst.DETAIL_UE_ADD) {
				insureUnemploy += dto.getAmount();
				continue;
			}
			if (dto.getUeInsType() == PayrollConst.DETAIL_UE_BREAK) {
				for (Iterator<DetailPbDto> itBreak =breakdown.iterator(); itBreak.hasNext();) {
					DetailPbDto dtoBreak = itBreak.next();
					if (dto.getDetailCode().equals(dtoBreak.getUpperCode())) {
						if (dtoBreak.getTotalType() == PayrollConst.DETAIL_TOTAL_UE) {
							insureUnemploy += dtoBreak.getAmount();
							continue;
						}
					}
				}
			}
		}
		insureUnemploy = insureUnemploy > 0 ? insureUnemploy : 0;
		header.setInsureUnemploy((int)insureUnemploy);
	}
	
	/**
	 * ېőΏۊzvZB
	 */
	public void calcTaxation() {
		long taxation = 0L;
		for (Iterator<DetailPaDto> it = allowance.iterator(); it.hasNext();) {
			DetailPaDto dto = it.next();
			if (dto.getTaxationType() == PayrollConst.DETAIL_TAX_ADD) {
				taxation += dto.getAmount();
				continue;
			}
			if (dto.getTaxationType() == PayrollConst.DETAIL_TAX_BREAK) {
				for (Iterator<DetailPbDto> itBreak =breakdown.iterator(); itBreak.hasNext();) {
					DetailPbDto dtoBreak = itBreak.next();
					if (dto.getDetailCode().equals(dtoBreak.getUpperCode())) {
						if (dtoBreak.getTotalType() == PayrollConst.DETAIL_TOTAL_TAX) {
							taxation += dtoBreak.getAmount();
							continue;
						}
					}
				}
			}
		}
		taxation = taxation > 0 ? taxation : 0;
		setSumAmount(PayrollConst.DTL_SUM_TAXATION, (int)taxation);
		header.setTaxation((int)taxation);
	}
	
	/**
	 * }{̐ݒ肷B
	 * @param dependent ݒ肷}{̐
	 */
	public void setDependent(byte dependent) {
		header.setDependent(dependent);
	}
	
	/**
	 * ЉیT̋z擾B
	 * @return ЉیT̋z
	 */
	public int getAfterDeduction() {
		int afterDeduction = getTaxation() - getSocInsTotal();
		return afterDeduction > 0 ? afterDeduction : 0;
	}
	
	/**
	 * Pݒ荀ڂ擾B
	 * @return Pݒ荀ڔz
	 */
	public String[][] getUnitItem() {
		List<DetailDto> list = new ArrayList<DetailDto>();
		for (int i = 0; i < time.size(); i++) {
			DetailDto dto = time.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < allowance.size(); i++) {
			DetailDto dto = allowance.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < deduction.size(); i++) {
			DetailDto dto = deduction.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < breakdown.size(); i++) {
			DetailDto dto = breakdown.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		for (int i = 0; i < sum.size(); i++) {
			DetailDto dto = sum.get(i);
			if (dto.getInputType() == PayrollConst.DETAIL_IN_UNIT) {
				list.add(dto);
			}
		}
		return getAryDetail(list, false);
	}
	
}
